clear;
clc;
fullScriptPath = matlab.desktop.editor.getActiveFilename();
[folderPath, ~, ~] = fileparts(fullScriptPath);
%% FILE1
%nomefile
file1 = 'C2_2025-07-22_14-55-12.txt';
% Define the names of the files you want to read
filename1 = fullfile(folderPath, file1);
% Importa i dati
data_import_1 = importdata(filename1,'\t');
% Visualizza i dati
data1=data_import_1.data(5:end,:);
disp(data_import_1);

%% GRAFICI
%BANK
figure(1)

subplot(2,1,1)
plot(data1(:,1)-data1(1,1),data1(:,9),"--k", 'LineWidth', 1.5)
hold on
plot(data1(:,1)-data1(1,1),data1(:,8),"k", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('bank [deg]');
legend('com','response', 'Location', 'southeast');
pbaspect([4 1 1]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 800, 400]) % [x, y, width, height]
ylim([-21 1])

subplot(2,1,2)
plot(data1(:,1)-data1(1,1),data1(:,14),"k", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('\deltaa [deg]');
pbaspect([4 1 1]) % Aspect ratio X:Y:Z
ylim([-6 6])
